function [avDist,varDist] = SFlabCalibrate(tphat,recChanList)
%
% Function that is used to find rough estimates of TDOA precision. N.B. The
% function assumes that all microphones were located at equal distance from
% the sound source.
% 
% function [avDist,varDist] = SFlabCalibrate(tphat,recChanList)
%
% INPUTS:
% tphat    -  Matrix with pulse times, element (:,m,n) contains the
%             pulse times for microphone m from speaker n.
% recChanList -  Vector with the recording channels that were used.
%
% OUTPUTS:
% avDist   -  Matrix with mean relative distances. Element (r,c) is the
%             mean of the relative distance between microphones r and c.
% varDist  -  Matrix with variance of relative distances. Element (r,c) is
%             the variance of the relative distance between microphones
%             r and c.
%
%

% Martin Skoglund and Karl Granstrm
% 2009-03-24

% Transform tphat to vector
% tphat = tphat(:);

% Size of tphat, (number of pulses)X(number of microphones)
[n_pulse, M] = size(tphat);

% Speed of sound in metres per second
v_sound = 340.29;

% Allocate memory
avDist = zeros(M,M);
varDist = zeros(M,M);

% Calculate mean and variance of relative distances
for micA = 1:M-1
    figure
    timeA = tphat(:,micA);
    for micB = micA+1:M
        timeB = tphat(:,micB);
        timeDiff = abs(timeA-timeB);
        distDiff = v_sound*timeDiff;
        avDist(micA,micB) = mean(distDiff);
        avDist(micB,micA) = avDist(micA,micB);
        varDist(micA,micB) = var(distDiff);
        varDist(micB,micA) = varDist(micA,micB);
        
        subplot(M-micA,1,micB-micA)
        plot(v_sound*(timeA-timeB))
        title(['Dist diff ' num2str(recChanList(micA))...
            ' and ' num2str(recChanList(micB))])
    end
end